/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.util;

import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class TransparentLogger
extends Logger {
    Logger logger;

    public static Logger getLogger(String name) {
        return new TransparentLogger(Logger.getLogger(name));
    }

    private TransparentLogger(Logger logger) {
        super("transparent" + logger, null);
        this.logger = logger;
    }

    public String toString() {
        Logger ll = this.logger;
        Level l = ll.getLevel();
        while (l == null) {
            ll = ll.getParent();
            l = ll.getLevel();
        }
        Logger hl = this.logger;
        Handler[] h = hl.getHandlers();
        while (h.length == 0) {
            hl = hl.getParent();
            h = hl.getHandlers();
        }
        String slevel = ll != this.logger ? "" + l + "(from " + ll + ")" : "" + l;
        return this.logger.getName() + "  " + slevel + "  " + h[0] + "@" + h[0].getLevel();
    }

    @Override
    public void warning(String msg) {
        this.logger.warning(msg);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logger.throwing(sourceClass, sourceMethod, thrown);
    }

    @Override
    public void severe(String msg) {
        this.logger.severe(msg);
    }

    @Override
    public synchronized void setUseParentHandlers(boolean useParentHandlers) {
        this.logger.setUseParentHandlers(useParentHandlers);
    }

    @Override
    public void setParent(Logger parent) {
        this.logger.setParent(parent);
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        this.logger.setLevel(newLevel);
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        this.logger.setFilter(newFilter);
    }

    @Override
    public synchronized void removeHandler(Handler handler) throws SecurityException {
        this.logger.removeHandler(handler);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg, thrown);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg, params);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg, param1);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.logger.logp(level, sourceClass, sourceMethod, msg, thrown);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logger.logp(level, sourceClass, sourceMethod, msg, params);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logger.logp(level, sourceClass, sourceMethod, msg, param1);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.logger.logp(level, sourceClass, sourceMethod, msg);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        this.logger.log(level, msg, thrown);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        this.logger.log(level, msg, params);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        this.logger.log(level, msg, param1);
    }

    @Override
    public void log(Level level, String msg) {
        this.logger.log(level, msg);
    }

    @Override
    public void log(LogRecord record) {
        this.logger.log(record);
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    @Override
    public void info(String msg) {
        this.logger.info(msg);
    }

    @Override
    public synchronized boolean getUseParentHandlers() {
        return this.logger.getUseParentHandlers();
    }

    @Override
    public String getResourceBundleName() {
        return this.logger.getResourceBundleName();
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    @Override
    public Logger getParent() {
        return this.logger.getParent();
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public Level getLevel() {
        return this.logger.getLevel();
    }

    @Override
    public synchronized Handler[] getHandlers() {
        return this.logger.getHandlers();
    }

    @Override
    public Filter getFilter() {
        return this.logger.getFilter();
    }

    @Override
    public void finest(String msg) {
        this.logger.finest(msg);
    }

    @Override
    public void finer(String msg) {
        this.logger.finer(msg);
    }

    @Override
    public void fine(String msg) {
        this.logger.fine(msg);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.logger.exiting(sourceClass, sourceMethod, result);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        this.logger.exiting(sourceClass, sourceMethod);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.logger.entering(sourceClass, sourceMethod, params);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.logger.entering(sourceClass, sourceMethod, param1);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        this.logger.entering(sourceClass, sourceMethod);
    }

    @Override
    public void config(String msg) {
        this.logger.config(msg);
    }

    @Override
    public synchronized void addHandler(Handler handler) throws SecurityException {
        this.logger.addHandler(handler);
    }
}

